" turns the selected line number to a comment box, can also add a title into the box
" mostly intended for use at the beginning of files that might require an intro to understand

function WrapLineInCommentBox(linenumber, ...)
    " make title an optional variable
    if a:0 > 0
        let title = a:1
    else
        let title = ''
    end
    execute 'r!echo' getbufline(bufnr('%'), a:linenumber, a:linenumber)[0] '| bash $HOME/scripts/commentbox.sh' title
    execute a:linenumber ."d"
endfunction

" switch between js/html file of the same name
function SwitchJS()
    let file_name = expand("%<")
    let ext = split(expand("%"), '\.')[-1]

    if ext == "js"
        let swap_to_file = join([file_name, ".html"], "")
        if filereadable(swap_to_file)
            :e %<.html
        else " in some projects this is common, so add a special case for this
            let swap_to_file = "index.html"
                if filereadable(swap_to_file)
                    :e index.html
                endif
        endif
    elseif ext == "html"
        let swap_to_file = join([file_name, ".js"], "")
        if filereadable(swap_to_file)
            :e %<.js
        else " if file of same name is not found, try to look for file matching name of parent directory
            let swap_to_file = join([expand('%:p:h:t'), ".js"], "")
            if filereadable(swap_to_file)
                :e %:p:h:t.js
            endif
        endif
    endif
endfunction

" turns a comment composed of multiple lines of // to a single multi-line /* */ type of comment
function! ToMultiLineComment()
     let start_line = line(".")
     let double_slash = '^\s*\/\/'

     " if no '//' at the beginning of line, bail and tell the user
     if (match(getline(start_line), double_slash) == -1)
        echohl WarningMsg | echo 'Cursor not in line with a multi-line "//" comment.' | echohl None
        return
     endif

     let end_line = start_line

     " pick up how many lines our change is going to affect
     while (match(getline(start_line - 1), double_slash) >= 0)
        let start_line = start_line - 1
     endwhile
     while (match(getline(end_line + 1), double_slash) >= 0)
        let end_line = end_line + 1
     endwhile

     " if we would only change one single line, bail and tell the user
     if (start_line == end_line)
        echohl WarningMsg | echo 'This comment is only a single line in length.' | echohl None
        return
     endif

     if (match(getline(end_line), '^\s*\/\/\s*$') >= 0)
        " The last line is just a '//' so we want to replace it with ' */'
        " instead of replacing it with ' *', and adding a new terminating '*/' line.
        execute end_line
        execute 's~//~ */~'
        let end_line = end_line - 1
     endif

     execute start_line
     execute 's~//~/*~'

     " this if block prevents an error from getting thrown when two comments are close to each other
     if (end_line >= (start_line+1))
         execute (start_line + 1) . ',' . end_line . 's~^\(\s*\)//~\1 *~'
         execute end_line + 1
     endif
endfunction

" turn a single line of /* */ comment to // type of comment
" also fixes weird comments like
" /* ...
" */ to a single line // type of comment 
function! OneLineMultiComment()
     let start_line = line(".") " gets current line number at cursor position
     let start_pat = '^\s*\/\*'
     let end_pat   = '^\s*\*\/\s*$'
     let single_pat = '^\s*\/\*\([^*\\]\|\\.\)*\*\/\s*$'

     if match(getline(start_line), single_pat) >= 0
      " A complete /* ... */ comment on one line.
      execute 's~^\(\s*\)/\*\(.\{-}\)\s*\*/~\1//\2~'
      return
     endif

     if match(getline(start_line), start_pat) >= 0
      " If a line starts with '/*'; assume the next line will start with '*/'
      let end_line = start_line + 1
     elseif match(getline(start_line), end_pat) >= 0  " getline(5)  gets text of line 5
      "match() returns -1 if not found, otherwise returns position where match is found
      " If a line starts with '*/'; assume the previous line will start with '/*'
      let end_line = start_line
      let start_line = end_line - 1
     endif

     " Make sure start_line starts with '/*', and end_line starts with '*/'
     if match(getline(start_line), start_pat) == -1 || match(getline(end_line), end_pat) == -1
      echohl WarningMsg | echo 'Invalid operation, should be in a /* ... */ comment' | echohl None
      return
     endif

     execute end_line
     normal! ddk
     execute 's~^\(\s*\)/\*\(.\{-}\)\s*$~\1//\2~'
endfunction
