let g:SpanishKeysEnabled=0

" I sometimes find this easier than changing keyboard layout,
" because I don't remember easily what's supposed to be where.

function! ToggleSpanishKeys()
    if !g:SpanishKeysEnabled
        call EnableSpanishKeys()
    else
        call DisableSpanishKeys()
    endif
endfunction

function! EnableSpanishKeys()
    echo "Enabling Spanish accents"
    let g:SpanishKeysEnabled=1

        inoremap <leader>a á<C-o>1l
        inoremap <leader>A Á<C-o>1l
        inoremap <leader>e é<C-o>1l
        inoremap <leader>E É<C-o>1l
        inoremap <leader>i í<C-o>1l
        inoremap <leader>I Í<C-o>1l
        inoremap <leader>o ó<C-o>1l
        inoremap <leader>O Ó<C-o>1l
        inoremap <leader>u ú<C-o>1l
        inoremap <leader>U Ú<C-o>1l
    inoremap <leader>n ñ<C-o>1l
endfunction

function! DisableSpanishKeys()
    echo "Disabling Spanish accents"
    let g:SpanishKeysEnabled=0

    iunmap <leader>a
    iunmap <leader>A
    iunmap <leader>e
    iunmap <leader>E
    iunmap <leader>i
    iunmap <leader>I
    iunmap <leader>o
    iunmap <leader>O
    iunmap <leader>u
    iunmap <leader>U
    iunmap <leader>n
endfunction
