"statusline, remove git related functions if we are exploring directories
if isdirectory(expand('%'))
    set laststatus=2
    set statusline=                          " left align
    set statusline+=%2*\                     " blank char
    set statusline+=%2*\ 0
    set statusline+=%2*\
    set statusline+=%1*\ <<
    set statusline+=%1*\ %f                  " short filename
    set statusline+=%1*\ >>
    set statusline+=%=                       " right align
    set statusline+=%*
    set statusline+=%3*\%h%m%r               " file flags (help, read-only, modified)
    set statusline+=%4*\ 0
    set statusline+=%3*\%.25F                " long filename (trimmed to 25 chars)
    set statusline+=%3*\::
    set statusline+=%3*\%l/%L\\|             " line count
    set statusline+=%3*\%y                   " file type
else
    set laststatus=2
    set statusline=                          " left align
    set statusline+=%2*\                     " blank char
    set statusline+=%2*\%{b:gitdiffs}        " include info about committed changes between current branch and master
    set statusline+=%2*\
    set statusline+=%1*\ <<
    set statusline+=%1*\ %f                  " short filename
    set statusline+=%1*\ >>
    set statusline+=%=                       " right align
    set statusline+=%*
    set statusline+=%3*\%h%m%r               " file flags (help, read-only, modified)
    set statusline+=%4*\%{b:gitbranch}       " include git branch
    set statusline+=%3*\%.25F                " long filename (trimmed to 25 chars)
    set statusline+=%3*\::
    set statusline+=%3*\%l/%L\\|             " line count
    set statusline+=%3*\%y                   " file type
    hi User1 ctermbg=black ctermfg=grey guibg=black guifg=grey
    hi User2 ctermbg=green ctermfg=black guibg=green guifg=black
    hi User3 ctermbg=black ctermfg=lightgreen guibg=black guifg=lightgreen
endif

"statusline helper functions

function! StatuslineGitBranch()
  let b:gitbranch=""
  let b:gitdiffs=""
  if &modifiable
    try
      lcd %:p:h
    catch
      return
    endtry
    let l:gitrevparse=system("git rev-parse --abbrev-ref HEAD")
    lcd -
    if l:gitrevparse!~"fatal: not a git repository"
        "name of our git branch, if we are in one
        let b:gitbranch="(".substitute(l:gitrevparse, '\n', '', 'g').") "
        "short info about committed changes of this branch vs master
        let b:gitdiffs=system('git diff --shortstat  $(git branch --show-current 2>/dev/null)  master 2>/dev/null | sed -E "s/([a-z ]+)
//g"')
    endif
  endif
endfunction
