#!/bin/bash

### commentbox #################################################################
# A simple script that makes it easy to generate a nicely formatted comment    #
# box around text (that looks something like this the one here)                #
################################################################################

if [ -t 0 ]; then
    echo "USAGE: This function reads from standard input for the contents of the comment box."
    exit 1
fi

# Grab stdin
STDIN=$(cat -)

# Check for the correct number of args
#if [ $# -eq 0 ]; then
#    echo "USAGE: ${0##*/} <title>" 1>&2
#    exit 1
#fi

# The number of columns to use for wrapping,
# minus 4 so the comment box doesn't exceed
# this value is variable, but caps at this value
# for small text, the box will be less wide

COLUMNS=76

if [ ${#STDIN} -lt $COLUMNS ]; then
    COLUMNS=${#STDIN}
fi

if [ ${#1} -ge $COLUMNS ]; then
    echo "Title is too long! Can not draw box."
    exit 1
fi

if [ $COLUMNS -eq 0 ]; then
    echo "Missing input!"
    exit 1
fi

# The border to print
BORDER=''

# Generate the border to be used along the
#+ top and bottom of the text.
for f in $(seq $((COLUMNS + 4))); do
        BORDER=${BORDER}'#'
done

# Print the top border
BORDER_TOP=$(awk -v title="$1" -v border_len=$COLUMNS 'BEGIN{printf "## "title" ";} END{while(length($0)<(border_len)){$0=$0"#"; } print substr($0, 1, border_len-length(title));}')

if [ -z "$1" ]; then
    BORDER_TOP=${BORDER}
fi

echo $BORDER_TOP


# Print the user's message
while read line; do
        printf "# %-${COLUMNS}s #\n" "$line"
done < <(fold -w ${COLUMNS} -s << EOF
$STDIN
EOF
)

# Print the bottom border
echo ${BORDER}
