#define PY_SSIZE_T_CLEAN
#include <Python.h>
#include <complex.h>
#include "kp.h"

static PyObject* py_gen_data(PyObject* self, PyObject* args, PyObject* kwargs) {
    static char* kwlist[] = {"b", "V_0", "Delta", NULL};
    double b = 1.0, V_0 = -5.0, Delta = 0.2;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|ddd", kwlist, &b, &V_0, &Delta)) {
        return NULL;
    }

    gen_data(b, V_0, Delta);

    Py_RETURN_NONE;
}

static PyMethodDef KPMethods[] = {
    {"gen_data", (PyCFunction)py_gen_data, METH_VARARGS | METH_KEYWORDS,
     "gen_data(b=1.0, V_0=-5.0, Delta=0.2) -> None\n"
     "Generates ./data.csv using hardcoded path; silent on I/O failure."},
    {NULL, NULL, 0, NULL}
};

static struct PyModuleDef kp_module = {
    PyModuleDef_HEAD_INIT,
    "kp",
    "Kronig–Penney data generator",
    -1,
    KPMethods
};

PyMODINIT_FUNC PyInit_kp(void) {
    return PyModule_Create(&kp_module);
}


