#!/bin/awk

#Another awk script for reorganizing data in CSV files.
#The necessity here was similar to some of the other files in here,
#the data format was too awkward for some process to work with, and this was the quickest way to fix it.

BEGIN{
    FS="@|;";
}
{
    swp = $1";"$2";"$3";"$4";"$5";"$6;
    tmp = swp;
    c = 0;
    for (i = 7; i <= NF; i++) {
        c++;
        tmp = tmp";"$i;
        if (c % 5 == 0) {
            print tmp;
            tmp = swp;
        }
    }
}

#HOW IT WORKS

#2927;1;CH0006539198;EUR;200;48543;968@0@91@76@3000;969@0@91@77@1000;970@0@91@78@100
#3824;1;DE000A1EWWW0;EUR;200;48543;968@0@91@76@3000;969@0@91@77@1000;970@0@91@78@100

#2927;1;CH0006539198;EUR;200;48543;968;0;91;76;3000
#2927;1;CH0006539198;EUR;200;48543;969;0;91;77;1000
#2927;1;CH0006539198;EUR;200;48543;970;0;91;78;100
#3824;1;DE000A1EWWW0;EUR;200;48543;968;0;91;76;3000
#3824;1;DE000A1EWWW0;EUR;200;48543;969;0;91;77;1000
#3824;1;DE000A1EWWW0;EUR;200;48543;970;0;91;78;100

# FS="@|;" -> Delimiter is either @ or ;
# take first 6 fields, save them into a variable called swp to turn them into a constant
# fields 7 to end (NF) fanned out into groups of 5, prefixed by constant swp
# on every 5th appended field, print line and reset buffer
# it's possible to change the magic number 5 by adding a variable from bash
# into BEGIN block -> if (chunk=="") {chunk=5}
# if (c % 5) -> if (c % chunk)
# call the awk script with -v chunk=<NUMBER>

