#!/bin/awk

#A small utility I created when I need some quick and dirty SQL data to test out some queries and ideas

function isNegative() {
    return rand();
}

function random(digits, pos_only) {
    negative = isNegative();
    if ((negative <= 0.5) && (pos_only == 0)) {
        return (rand() * (10 ** digits)) * -1;
    } else {
        return (rand() * (10 ** digits));
    }
}

function generateNumber(digits, pos_only, decimal, delimiter){
    result = random(digits, pos_only);
    if (decimal == 1) {
        return int(result)""delimiter;
    } else {
        return result""delimiter;
    }
}

BEGIN {
    if (digits == ""){digits = 3;}
    if (rows == ""){rows = 10;}
    if (columns == ""){columns = 4;}
    if (pos_only == ""){pos_only = 1;}
    if (decimal == ""){decimal = 1;}
    if (delimiter == ""){delimiter = ","}
    DELIMITER_LEN=length(delimiter)+1;

    for(i = 0; i < rows; i++) {
        x="";
        for(j = 0; j < columns; j++) {
            if (j + 1 >= columns){
                x = x""generateNumber(digits, pos_only, decimal, delimiter)"\n";
            } else {
                x = x""generateNumber(digits, pos_only, decimal, delimiter);
            }
        }
        print substr(x, 1, length(x)-DELIMITER_LEN);

    }
}
