#!/bin/awk

BEGIN{
    FS = ","
}

(NR == 1) {
    for (i = 1; i <= NF; i++) {
        if ($i ~ /^[0-9]+$/) {
            numeric[i] = 1;
            header[i] = $i;
            cols++;
        }
    }
    if (cols == 0) {
        exit 1;
    }
    next;
}
{
    for (i = 1; i <= NF; i++) {
        if (i in numeric && $i ~ /^[0-9]+$/) {
            sum[i] += $i;
        }
    }
}
END{
    printf "Column totals:\n"
    for (i = 1; i <= NF; i++) {
        if (i in numeric) {
            printf "  %-12s : %d\n", header[i] ":", sum[i];
        }
    }
}
