#!/bin/bash

function check_unmerged_git_branches() {

    GIT_DIR=$1
    EMAIL=$2

    if [ -z $GIT_DIR ]; then
        echo "Must specify the path of a git repo"
        return 1
    fi

    if [ -z $EMAIL ]; then
        echo "Must specify recipient(s)"
        return 1
    fi

    if [ ! -d "$GIT_DIR/.git" ]; then
        echo "Directory is not a git repo: $GIT_DIR"
        return 1
    fi

    THIS_DIR=$(echo $PWD);
    THIS_SCRIPT=$(echo $PWD | sed -E 's/(.*[^a-z\-])?([a-z\-]{1,}).*/\2/'); #name of the directory this script is in - this makes sense if the directory name is more relevant and the script itself is just named something like "run"
    NOW=$(date +%Y%m%d)

    if [ -f ./branches.txt ]; then
        rm ./branches.txt;
    fi

    if [ -f ./branches_results.txt ]; then
        rm ./branches_results.txt;
    fi

    cd $GIT_DIR;

    for branch in $(git branch -r --no-merged | grep -v "HEAD"); do
        echo -e $branch"," $(git log --no-merges -n1 --format="%ct, %ci, %cr, %an, %ae" $branch | head -n1) | xargs echo  >> "$THIS_DIR/branches.txt";
    done

    cd $THIS_DIR;

    echo -e "Unmerged old branches check\nThis script checks for any un-merged branches on the remote that are older than 30 days.\n\n" >> ./branches_results.txt

    cat ./branches.txt | awk 'BEGIN{FS=","; prev_month_stamp=(systime() - 30 * 24 * 60 * 60);}{if($2 > prev_month_stamp){next;} else {print $0;}}' >> ./branches_results.txt;

    cat << EOF >> branches_results.txt

    Please check if you have any unmerged branches in the remote repository, and either merge them or delete them.
    -------------------------------------------------------------------------------------------
    Generated by ${THIS_SCRIPT}
EOF

    cat ./branches_results.txt | mail -s "[INFO]: Unmerged old branches check @ ${NOW}" "$EMAIL"
}
