# Print Prime Numbers

Problem Statement:

Write a query to print all prime numbers less than or equal to 1000. Print your result on a single line, and use the ampersand character as your separator (instead of a space).

For example, the output for all prime numbers less than 10 would be:

```
2&3&5&7
```

Solution:

```sql
CREATE TEMPORARY TABLE Numbers (
    Number INT PRIMARY KEY
);

INSERT INTO Numbers
WITH RECURSIVE OddNumbers AS (
    SELECT 3 AS Number
    UNION ALL
    SELECT Number + 2 FROM OddNumbers WHERE Number + 2 <= 1000
)
SELECT Number FROM OddNumbers;

INSERT INTO Numbers VALUES(2);

CREATE TEMPORARY TABLE Divisors AS
SELECT * FROM Numbers WHERE Number > 1;

SELECT GROUP_CONCAT(N.Number SEPARATOR '&') AS PrimeNumbers
FROM Numbers N
WHERE NOT EXISTS (
    SELECT 1
    FROM Divisors D
    WHERE D.Number * D.Number <= N.Number
      AND N.Number % D.Number = 0
);
```
