#!/bin/bash

function find_in_paragraph() {

    PAT="$1"
    FILE="$2"

    if [ -z $PAT ]; then
        echo "missing pattern"
        return 1;
    fi

    if [ -z $FILE ]; then
        echo "missing file"
        return 1;
    fi

    sed -e '/./{H;$!d;}' -e 'x;/'$PAT'/!d;'

    #Explanation for the random wanderer looking in here:
    #'/./{H;$!d;}' -> append each line to the old space, and keep buffering, but only if the line is NOT blank
    #x -> at a blank line (or end of file) swap butter into pattern space
    #/'$PAT'/!d -> if $PAT is NOT in the paragraph, then delete the paragraph

    #if you want to match more stuff, just keep slapping more patterns into it -> 'x;/'$PAT'/!d;/'$PAT2'/!d;' etc.
}
