function flatten_newlines() {

    FILE="$1"

    if [ -z $FILE ]; then
        echo "A file is needed"
        return 1
    fi

    sed ':m;$!{N;s/\n/ /;bm;}' "$FILE"

    #Explanation for the random wanderer looking in here:
    #:m     ->         define label m
    #$!{}   ->         If current line is not the last line
    #N      ->         append next line to pattern space, aka join the lines
    #s\n/ / ->         replace the newline between them with a space
    #b m    ->         loop back to label m
}
