#!/bin/bash

function replace_match_and_next2() {

    PAT="$1"
    FILE="$2"

    if [ -z $PAT ]; then
        echo "A pattern is needed";
        return 1;
    fi

    if [ -z $FILE ]; then
        echo "A file is needed";
        return 1;
    fi

    sed -n -e '/'$PAT'/!p;: m' -e '//{' -e '$!{' -e 'n;n;b m' -e '}' -e'}' $FILE

    #Explanation for the random wanderer looking in here:
    #sed -n \
    #  -e '/'$PAT'/!p'       print lines that do NOT match $PAT
    #  -e ':m'                  define label "m"
    #  -e '//{'                 if line matches $PAT again
    #  -e '  $!{'               and it's NOT the last line
    #  -e '    n; n; b m'       skip next two lines and go back to label "m"
    #  -e '  }'                 end inner conditional
    #  -e '}'                   end outer conditional

    #sometimes this can be useful for cutting parts from responses that are not needed
    #but have no control over

}
