SELECT RPAD(concat(t.trx_id,':',t.trx_mysql_thread_id),30,' ') as 'trx_id:trx_mysql_thread_id       ',
       ifnull(concat('by:',l.blocking_lock_id),'no') as locked,
       RPAD(IFNULL(CONCAT(processlist_user,'@',processlist_host,':',PROCESSLIST_DB),''),50,' ') AS 'user_db
               ',
       RPAD(t.trx_state,10,' ') as 'state     ',
       RPAD(t.trx_started,20,' ') as 'started             ',
       RPAD(timediff(now(), t.trx_started),10,' ') as 'runtime   ',
       RPAD(t.trx_weight,10,' ') as 'trx_weight',
       t.trx_query
FROM information_schema.innodb_trx t
       INNER JOIN performance_schema.threads p ON  p.processlist_id=t.trx_mysql_thread_id
       LEFT JOIN information_schema.innodb_lock_waits l ON l.requesting_trx_id=t.trx_id
     #WHERE  t.trx_query is NULL
ORDER by t.trx_started;
